/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.parsing.ast;

import beaver.Symbol;
import com.aptana.core.util.SourcePrinter;
import com.aptana.js.core.parsing.ast.JSArgumentsNode;
import com.aptana.js.core.parsing.ast.JSArrayNode;
import com.aptana.js.core.parsing.ast.JSAssignmentNode;
import com.aptana.js.core.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.js.core.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.js.core.parsing.ast.JSBreakNode;
import com.aptana.js.core.parsing.ast.JSCaseNode;
import com.aptana.js.core.parsing.ast.JSCatchNode;
import com.aptana.js.core.parsing.ast.JSCommaNode;
import com.aptana.js.core.parsing.ast.JSConditionalNode;
import com.aptana.js.core.parsing.ast.JSConstructNode;
import com.aptana.js.core.parsing.ast.JSContinueNode;
import com.aptana.js.core.parsing.ast.JSDeclarationNode;
import com.aptana.js.core.parsing.ast.JSDefaultNode;
import com.aptana.js.core.parsing.ast.JSDoNode;
import com.aptana.js.core.parsing.ast.JSElementsNode;
import com.aptana.js.core.parsing.ast.JSElisionNode;
import com.aptana.js.core.parsing.ast.JSEmptyNode;
import com.aptana.js.core.parsing.ast.JSFalseNode;
import com.aptana.js.core.parsing.ast.JSFinallyNode;
import com.aptana.js.core.parsing.ast.JSForInNode;
import com.aptana.js.core.parsing.ast.JSForNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSGetElementNode;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSGroupNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSIfNode;
import com.aptana.js.core.parsing.ast.JSInvokeNode;
import com.aptana.js.core.parsing.ast.JSLabelledNode;
import com.aptana.js.core.parsing.ast.JSNameValuePairNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSNullNode;
import com.aptana.js.core.parsing.ast.JSNumberNode;
import com.aptana.js.core.parsing.ast.JSObjectNode;
import com.aptana.js.core.parsing.ast.JSParametersNode;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.js.core.parsing.ast.JSPostUnaryOperatorNode;
import com.aptana.js.core.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.js.core.parsing.ast.JSRegexNode;
import com.aptana.js.core.parsing.ast.JSReturnNode;
import com.aptana.js.core.parsing.ast.JSStatementsNode;
import com.aptana.js.core.parsing.ast.JSStringNode;
import com.aptana.js.core.parsing.ast.JSSwitchNode;
import com.aptana.js.core.parsing.ast.JSThisNode;
import com.aptana.js.core.parsing.ast.JSThrowNode;
import com.aptana.js.core.parsing.ast.JSTreeWalker;
import com.aptana.js.core.parsing.ast.JSTrueNode;
import com.aptana.js.core.parsing.ast.JSTryNode;
import com.aptana.js.core.parsing.ast.JSVarNode;
import com.aptana.js.core.parsing.ast.JSWhileNode;
import com.aptana.js.core.parsing.ast.JSWithNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.Iterator;

public class JSFormatWalker
extends JSTreeWalker {
    private SourcePrinter _printer = new SourcePrinter();

    protected void addSemicolon(IParseNode node) {
        if (node instanceof JSNode && ((JSNode)node).getSemicolonIncluded()) {
            this._printer.print(';');
        }
    }

    protected void formatBinaryOperator(IParseNode node, IParseNode lhs, Symbol operator, IParseNode rhs) {
        this.formatNode(lhs);
        this._printer.print(' ').print(operator.value).print(' ');
        this.formatNode(rhs);
        this.addSemicolon(node);
    }

    protected void formatNaryNode(IParseNode node, String openText, String delimiter, String closeText) {
        this._printer.print(openText);
        boolean first = true;
        for (IParseNode child : node) {
            if (!first) {
                this._printer.print(delimiter);
            } else {
                first = false;
            }
            this.formatNode(child);
        }
        this._printer.print(closeText);
        this.addSemicolon(node);
    }

    protected void formatNode(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept(this);
        }
    }

    public String getText() {
        return this._printer.toString();
    }

    protected boolean hasSemicolon(IParseNode node) {
        return node instanceof JSNode ? ((JSNode)node).getSemicolonIncluded() : false;
    }

    protected boolean isNotEmpty(IParseNode node) {
        boolean result = true;
        if (node instanceof JSNode) {
            result = !((JSNode)node).isEmpty();
        }
        return result;
    }

    public void visit(JSArgumentsNode node) {
        this.formatNaryNode((IParseNode)node, "(", ", ", ")");
    }

    public void visit(JSArrayNode node) {
        this.formatNaryNode((IParseNode)node, "[", ", ", "]");
    }

    public void visit(JSAssignmentNode node) {
        this.formatBinaryOperator((IParseNode)node, node.getLeftHandSide(), node.getOperator(), node.getRightHandSide());
    }

    public void visit(JSBinaryArithmeticOperatorNode node) {
        this.formatBinaryOperator((IParseNode)node, node.getLeftHandSide(), node.getOperator(), node.getRightHandSide());
    }

    public void visit(JSBinaryBooleanOperatorNode node) {
        this.formatBinaryOperator((IParseNode)node, node.getLeftHandSide(), node.getOperator(), node.getRightHandSide());
    }

    public void visit(JSBreakNode node) {
        String text;
        Symbol label = node.getLabel();
        this._printer.print("break");
        if (label != null && (text = (String)label.value) != null && text.length() > 0) {
            this._printer.print(' ').print(text);
        }
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSCaseNode node) {
        this._printer.print("case ");
        this.formatNode(node.getExpression());
        this._printer.print(": ");
        boolean first = true;
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            IParseNode child = (IParseNode)iterator.next();
            if (first) {
                first = false;
                continue;
            }
            this.formatNode(child);
        }
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSCatchNode node) {
        this._printer.print("catch (");
        this.formatNode(node.getIdentifier());
        this._printer.print(") ");
        this.formatNode(node.getBody());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSCommaNode node) {
        this.formatNaryNode((IParseNode)node, "", ", ", "");
    }

    public void visit(JSConditionalNode node) {
        this.formatNode(node.getTestExpression());
        this._printer.print(" ? ");
        this.formatNode(node.getTrueExpression());
        this._printer.print(" : ");
        this.formatNode(node.getFalseExpression());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSConstructNode node) {
        this._printer.print("new ");
        this.formatNode(node.getExpression());
        this.formatNode(node.getArguments());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSContinueNode node) {
        String text;
        Symbol label = node.getLabel();
        this._printer.print("continue");
        if (label != null && (text = (String)label.value) != null && text.length() > 0) {
            this._printer.print(' ').print(text);
        }
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSDeclarationNode node) {
        this.formatNode(node.getIdentifier());
        IParseNode value = node.getValue();
        if (value instanceof JSNode && !((JSNode)value).isEmpty()) {
            this._printer.print(" = ");
            this.formatNode(value);
        }
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSDefaultNode node) {
        this.formatNaryNode((IParseNode)node, "default: ", "", "");
    }

    public void visit(JSDoNode node) {
        this._printer.print("do ");
        IParseNode body = node.getBody();
        this.formatNode(body);
        if (body.getNodeType() != 21 && !this.hasSemicolon(body)) {
            this._printer.print(';');
        }
        this._printer.print(" while (");
        this.formatNode(node.getCondition());
        this._printer.print(')');
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSElementsNode node) {
        this.formatNaryNode((IParseNode)node, "", ", ", "");
    }

    public void visit(JSElisionNode node) {
        this.formatNaryNode((IParseNode)node, "", ", ", "");
    }

    public void visit(JSEmptyNode node) {
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSFalseNode node) {
        this._printer.print(node.getText());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSFinallyNode node) {
        this._printer.print("finally ");
        this.formatNode(node.getBlock());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSForInNode node) {
        this._printer.print("for (");
        this.formatNode(node.getInitializer());
        this._printer.print(" in ");
        this.formatNode(node.getExpression());
        this._printer.print(") ");
        this.formatNode(node.getBody());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSForNode node) {
        IParseNode initializer = node.getInitializer();
        IParseNode condition = node.getCondition();
        IParseNode advance = node.getAdvance();
        IParseNode body = node.getBody();
        this._printer.print("for (");
        if (this.isNotEmpty(initializer)) {
            this.formatNode(initializer);
        }
        this._printer.print(';');
        if (this.isNotEmpty(condition)) {
            this._printer.print(' ');
            this.formatNode(condition);
        }
        this._printer.print(';');
        if (this.isNotEmpty(advance)) {
            this._printer.print(' ');
            this.formatNode(advance);
        }
        this._printer.print(") ");
        this.formatNode(body);
        if (body.getNodeType() != 21) {
            this.addSemicolon((IParseNode)node);
        }
    }

    public void visit(JSFunctionNode node) {
        String name = node.getName().getText();
        this._printer.print("function ");
        if (name != null && name.length() > 0) {
            this._printer.print(name).print(' ');
        }
        this.formatNode(node.getParameters());
        this._printer.print(' ');
        this.formatNode(node.getBody());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSGetElementNode node) {
        this.formatNode(node.getLeftHandSide());
        this._printer.print('[');
        this.formatNode(node.getRightHandSide());
        this._printer.print(']');
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSGetPropertyNode node) {
        this.formatNode(node.getLeftHandSide());
        this._printer.print('.');
        this.formatNode(node.getRightHandSide());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSGroupNode node) {
        this._printer.print('(');
        this.formatNode(node.getExpression());
        this._printer.print(')');
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSIdentifierNode node) {
        this._printer.print(node.getText());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSIfNode node) {
        IParseNode trueBlock = node.getTrueBlock();
        IParseNode falseBlock = node.getFalseBlock();
        this._printer.print("if (");
        this.formatNode(node.getCondition());
        this._printer.print(") ");
        this.formatNode(trueBlock);
        if (this.isNotEmpty(falseBlock)) {
            this._printer.print(" else ");
            this.formatNode(falseBlock);
        }
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSInvokeNode node) {
        this.formatNode((IParseNode)node.getExpression());
        this.formatNode((IParseNode)node.getArguments());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSLabelledNode node) {
        this.formatNode(node.getLabel());
        this._printer.print(": ");
        this.formatNode(node.getBlock());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSNameValuePairNode node) {
        if (node.getColon() != null) {
            this.formatNode(node.getName());
            this._printer.print(": ");
            this.formatNode(node.getValue());
            this.addSemicolon((IParseNode)node);
        } else if (node.getParameters() != null) {
            this._printer.print("set ");
            this.formatNode(node.getName());
            this.formatNode((IParseNode)node.getParameters());
            this._printer.print(' ');
            this.formatNode(node.getValue());
            this.addSemicolon((IParseNode)node);
        } else {
            this._printer.print("get ");
            this.formatNode(node.getName());
            this._printer.print(' ');
            this.formatNode(node.getValue());
            this.addSemicolon((IParseNode)node);
        }
    }

    public void visit(JSNullNode node) {
        this._printer.print(node.getText());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSNumberNode node) {
        this._printer.print(node.getText());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSObjectNode node) {
        this.formatNaryNode((IParseNode)node, "{", ", ", "}");
    }

    public void visit(JSParametersNode node) {
        this.formatNaryNode((IParseNode)node, "(", ", ", ")");
    }

    public void visit(JSParseRootNode node) {
        boolean first = true;
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            IParseNode child = (IParseNode)iterator.next();
            if (!first) {
                this._printer.print(' ');
            } else {
                first = false;
            }
            this.formatNode(child);
        }
    }

    public void visit(JSPostUnaryOperatorNode node) {
        this.formatNode(node.getExpression());
        switch (node.getNodeType()) {
            case 59: {
                this._printer.print("--");
                break;
            }
            case 60: {
                this._printer.print("++");
            }
        }
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSPreUnaryOperatorNode node) {
        IParseNode expression = node.getExpression();
        switch (node.getNodeType()) {
            case 49: {
                this._printer.print("delete ");
                break;
            }
            case 50: {
                this._printer.print('!');
                break;
            }
            case 51: {
                this._printer.print('-');
                break;
            }
            case 52: {
                this._printer.print("--");
                break;
            }
            case 53: {
                this._printer.print('+');
                break;
            }
            case 54: {
                this._printer.print("++");
                break;
            }
            case 55: {
                this._printer.print('~');
                break;
            }
            case 56: {
                this._printer.print("typeof");
                if (expression.getNodeType() == 58) break;
                this._printer.print(' ');
                break;
            }
            case 57: {
                this._printer.print("void ");
            }
        }
        this.formatNode(expression);
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSRegexNode node) {
        this._printer.print(node.getText());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSReturnNode node) {
        IParseNode expression = node.getExpression();
        this._printer.print("return");
        if (this.isNotEmpty(expression)) {
            this._printer.print(' ');
            this.formatNode(expression);
        }
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSStatementsNode node) {
        this.formatNaryNode((IParseNode)node, "{", "", "}");
    }

    public void visit(JSStringNode node) {
        this._printer.print(node.getText());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSSwitchNode node) {
        this._printer.print("switch (");
        this.formatNode(node.getExpression());
        this._printer.print(") {");
        boolean first = true;
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            IParseNode child = (IParseNode)iterator.next();
            if (first) {
                first = false;
                continue;
            }
            this.formatNode(child);
        }
        this._printer.print('}');
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSThisNode node) {
        this._printer.print(node.getText());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSThrowNode node) {
        this._printer.print("throw ");
        this.formatNode(node.getExpression());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSTrueNode node) {
        this._printer.print(node.getText());
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSTryNode node) {
        IParseNode catchBlock = node.getCatchBlock();
        IParseNode finallyBlock = node.getFinallyBlock();
        this._printer.print("try ");
        this.formatNode(node.getBody());
        if (this.isNotEmpty(catchBlock)) {
            this._printer.print(' ');
            this.formatNode(catchBlock);
        }
        if (this.isNotEmpty(finallyBlock)) {
            this._printer.print(' ');
            this.formatNode(finallyBlock);
        }
        this.addSemicolon((IParseNode)node);
    }

    public void visit(JSVarNode node) {
        this.formatNaryNode((IParseNode)node, "var ", ", ", "");
    }

    public void visit(JSWhileNode node) {
        IParseNode body = node.getBody();
        this._printer.print("while (");
        this.formatNode(node.getCondition());
        this._printer.print(") ");
        this.formatNode(body);
        if (body.getNodeType() == 21) {
            this.addSemicolon((IParseNode)node);
        }
    }

    public void visit(JSWithNode node) {
        this._printer.print("with (");
        this.formatNode(node.getExpression());
        this._printer.print(") ");
        this.formatNode(node.getBody());
        this.addSemicolon((IParseNode)node);
    }

    protected void visitChildren(JSNode node) {
        super.visitChildren(node);
    }
}

